/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.animation;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.bernie.geckolib.animation.object.EasingType;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Variable;
import software.bernie.geckolib.util.MiscUtil;

public record Keyframe(double startTime, double length, MathValue startValue, MathValue endValue, EasingType easingType, MathValue[] easingArgs) {
    public Keyframe(double startTime, double length, MathValue startValue, MathValue endValue) {
        this(startTime, length, startValue, endValue, EasingType.LINEAR);
    }

    public Keyframe(double startTime, double length, MathValue startValue, MathValue endValue, EasingType easingType) {
        this(startTime, length, startValue, endValue, easingType, new MathValue[0]);
    }

    public Keyframe(double startTime, double length, MathValue startValue, MathValue endValue, EasingType easingType, List<MathValue> easingArgs) {
        this(startTime, length, startValue, endValue, easingType, easingArgs.toArray(new MathValue[0]));
    }

    public Set<Variable> getUsedVariables() {
        ReferenceOpenHashSet usedVariables = new ReferenceOpenHashSet();
        if (this.startValue.isMutable()) {
            usedVariables.addAll(this.startValue.getUsedVariables());
        }
        if (this.endValue.isMutable()) {
            usedVariables.addAll(this.endValue.getUsedVariables());
        }
        for (MathValue easingArg : this.easingArgs) {
            if (!easingArg.isMutable()) continue;
            usedVariables.addAll(easingArg.getUsedVariables());
        }
        return usedVariables;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length, this.startValue, this.endValue, this.easingType, Arrays.hashCode(this.easingArgs));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Keyframe other = (Keyframe)obj;
        if (!MiscUtil.areFloatsEqual(this.length, other.length)) {
            return false;
        }
        if (!this.startValue.equals(other.startValue) || !this.endValue.equals(other.endValue)) {
            return false;
        }
        if (this.easingType != other.easingType) {
            return false;
        }
        return Arrays.equals(this.easingArgs, other.easingArgs);
    }
}

